<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;




Route::get('/test-db', function() {
  try {
      DB::connection()->getPdo();
      return response()->json([
          'status' => 'success',
          'message' => 'Connected to database: ' . DB::connection()->getDatabaseName(),
      ]);
  } catch (\Exception $e) {
      return response()->json([
          'status' => 'error',
          'message' => 'Database connection failed: ' . $e->getMessage(),
      ], 500);
  }
});
Route::group(['namespace' => 'App\Http\Controllers' ,'middleware' => 'api', 'prefix' => 'shared'], function(){
  Route::post('export/excel', 'SharedController@handleXLSXExport');
  Route::get('notifications/badges', 'SharedController@getNotificationBadge');
});

Route::group(['namespace' => 'App\Http\Controllers\Auth' ,'middleware' => 'api', 'prefix' => 'auth'], function(){
    Route::post('login', 'AuthController@login')->middleware(['throttle:60,1']);
    Route::get('logout', 'AuthController@logout');
    Route::get('refresh', 'AuthController@refresh');
    Route::get('me', 'AuthController@me');
    Route::post('me', 'AuthController@updateUser');
    Route::post('change-password', 'AuthController@changePassword');
    Route::get('notifications/read', 'AuthController@readNotifications');
    Route::get('notifications/read/{id}', 'AuthController@readSingleNotifications');
    Route::get('notifications/today', 'AuthController@getNotificationsForToday');
});

//Stock API'S
Route::group(['namespace' => 'App\Http\Controllers\Stock' ,'middleware' => 'auth:api', 'prefix' => 'stock'], function(){
  Route::group(['prefix' => 'units'], function(){
    Route::get('', 'UnitsController@index');
    Route::get('show/{id}', 'UnitsController@show');
    Route::post('store', 'UnitsController@store');
    Route::get('destroy/{id}', 'UnitsController@destroy');
  });

  Route::group(['prefix' => 'expensesCategory'], function(){
    Route::get('', 'ExpenseCategoryController@index');
    Route::get('categories', 'ExpenseCategoryController@ExpensesCategories');
    Route::get('search', 'ExpenseCategoryController@search');
    Route::get('show/{id}', 'ExpenseCategoryController@show');
    Route::post('store', 'ExpenseCategoryController@store');
    Route::get('destroy/{id}', 'ExpenseCategoryController@destroy');
  });

  Route::group(['prefix' => 'expenses'], function(){
    Route::get('', 'ExpenseController@index');
    Route::get('show/{id}', 'ExpenseController@show');
    Route::post('store', 'ExpenseController@store');
    Route::get('destroy/{id}', 'ExpenseController@destroy');
  });

  Route::group(['prefix'=> 'clients'], function(){
    Route::get('','ClientsController@index');
    Route::get('search', 'ClientsController@search');
    Route::get('show/{id}', 'ClientsController@show');
    Route::post('store', 'ClientsController@store');
    Route::get('destroy/{id}', 'ClientsController@destroy');
  });
  
  Route::group(['prefix' =>'categories'], function(){
    Route::get('', 'CategoriesController@index');
    Route::get('subcategory', 'CategoriesController@subcategory');
    Route::get('show/{id}', 'CategoriesController@show');
    Route::post('store', 'CategoriesController@store');
    Route::get('destroy/{id}', 'CategoriesController@destroy');
  });

  Route::group(['prefix' => 'suppliers'], function(){
    Route::get('', 'SuppliersController@index');
    Route::get('search', 'SuppliersController@search');
    Route::get('show/{id}', 'SuppliersController@show');
    Route::post('store', 'SuppliersController@store');
    Route::get('destroy/{id}', 'SuppliersController@destroy');
    Route::get('bulk-destroy/{ids}', 'SuppliersController@bulkDelete');
  });

  Route::group(['prefix' => 'products'], function(){
    Route::get('', 'ProductsController@index');
    Route::get('extras', 'ProductsController@extras');
    Route::get('search', 'ProductsController@search');
    Route::get('show/{id}', 'ProductsController@show');
    Route::post('store', 'ProductsController@store');
    Route::post('store/file', 'ProductsController@storeFile');
    Route::get('expired', 'ProductsController@expired');
    Route::get('expiredInPeriod', 'ProductsController@expirationCheckInthreeMo');
    Route::get('destroy/{id}', 'ProductsController@destroy');
    Route::get('bulk-destroy/{ids}', 'ProductsController@bulkDelete');
  });

  Route::group(['prefix' => 'inventory'], function(){
    /** For Receives */
    Route::post('receives/store', 'StockController@receive');
    Route::get('receives/show/{reference}', 'StockController@showReceive');
    Route::get('receives/{id}/destroy', 'StockController@deleteReceive');
    Route::get('receives/{id}/items', 'StockController@getReceiveItems');
    Route::get('receives/{id}/items/{itemId}/destroy', 'StockController@deleteReceiveItem');
   
    /** For Transfers */
    Route::post('transfers/store', 'StockController@transfer');
    Route::get('transfers/show/{reference}', 'StockController@showTransfer');
    Route::get('transfers/{id}/destroy', 'StockController@deleteTransfer');
    Route::get('transfers/{id}/items', 'StockController@getTransferItems');
    Route::get('transfers/{id}/items/{itemId}/destroy', 'StockController@deleteTransferItem');
  });

  Route::group(['prefix' => 'reports'], function(){
    Route::get('receives/{reference?}', 'ReportsController@getReceivesReport');
    Route::get('transfers', 'ReportsController@getTransfersReport');  
    Route::get('requisitions/{reference?}', 'RequisitionsController@index');  
    Route::get('proforma/{reference?}', 'ProformaController@index');  
    Route::get('delivery/{reference?}', 'DeliveryNoteController@index');  
    Route::get('purchase-order/{reference?}', 'PurchaseOrderController@index');  
    Route::get('adjustments', 'AdjustmentsController@index');  
    Route::get('tracker', 'ReportsController@getTrackerReport');  
    Route::get('store-status', 'ReportsController@trackProductsStock');  
    Route::get('dashboard', 'ReportsController@getDashboard');  
    Route::get('dashboard/cards-filter', 'ReportsController@filterDashboardCards');  
  });

  Route::group(['prefix' => 'requisitions'], function(){
    Route::get('show/{reference}/items', 'RequisitionsController@getItems');
    Route::get('status/{id}update', 'RequisitionsController@updateStatus');
    Route::post('store', 'RequisitionsController@store');
    Route::get('destroy/{id}', 'RequisitionsController@destroy');
    Route::get('items/{itemId}/destroy', 'RequisitionsController@deleteItem');
  });

  Route::group(['prefix' => 'proforma'], function(){
    Route::get('show/{reference}/items', 'ProformaController@getItems');
    Route::get('status/{id}update', 'ProformaController@updateStatus');
    Route::post('store', 'ProformaController@store');
    Route::get('approved/{reference}', 'ProformaController@approveProforma');
    Route::get('destroy/{id}', 'ProformaController@destroy');
    Route::get('items/{itemId}/destroy', 'ProformaController@deleteItem');
  });

  Route::group(['prefix' => 'delivery'], function(){
    Route::get('show/{reference}/items', 'DeliveryNoteController@getItems');
    Route::post('invoicing', 'DeliveryNoteController@generateInvoice');
    Route::get('status/{id}update', 'DeliveryNoteController@updateStatus');
    Route::get('destroy/{id}', 'DeliveryNoteController@destroy');
    Route::get('items/{itemId}/destroy', 'DeliveryNoteController@deleteItem');
  });

  Route::group(['prefix' => 'purchase-order'], function(){
    Route::get('show/{reference}/items', 'PurchaseOrderController@getItems');
    Route::get('status/{id}update', 'PurchaseOrderController@updateStatus');
    Route::post('store', 'PurchaseOrderController@store');
    Route::post('editOrder', 'PurchaseOrderController@editOrder');
    Route::get('verify/{id}', 'PurchaseOrderController@verifyPurchaseOrder');
    Route::get('paid/{id}', 'PurchaseOrderController@paidPurchaseOrder');
    Route::get('destroy/{id}', 'PurchaseOrderController@destroy');
    Route::get('items/{itemId}/destroy', 'PurchaseOrderController@deleteItem');
  });

  Route::group(['prefix' => 'adjustments'], function(){
    Route::get('show/{reference}/items', 'AdjustmentsController@getItems');
    Route::post('store', 'AdjustmentsController@store');
    Route::get('destroy/{id}', 'AdjustmentsController@destroy');
  });

  Route::group(['prefix' => 'currency'], function(){
    Route::get('', 'CurrencyController@index');
    Route::get('search', 'CurrencyController@search');
    Route::get('show/{id}', 'CurrencyController@show');
    Route::post('store', 'CurrencyController@store');
    Route::get('destroy/{id}', 'CurrencyController@destroy');
  });

  Route::group(['prefix' => 'paymentmode'], function(){
    Route::get('', 'PaymentModeController@index');
    Route::get('search', 'PaymentModeController@search');
    Route::get('show/{id}', 'PaymentModeController@show');
    Route::post('store', 'PaymentModeController@store');
    Route::get('destroy/{id}', 'PaymentModeController@destroy');
  });

  Route::group(['prefix' => 'imports'], function(){
    Route::post('', 'ProductsController@ImportProducts');
    Route::post('store', 'ProductsController@storeImported');
  });

  Route::group(['prefix' => 'pos'], function(){
    Route::get('sales', 'POSController@index');
    Route::get('dashboard', 'POSController@getDashboardData');
    Route::get('dashboard/cards-filter', 'POSController@filterDashboardCards');
    Route::get('items', 'POSController@salesItems');
    Route::get('payments-modes', 'POSController@getPaymentMethod');
    Route::get('payment-history', 'POSController@getPaymentHistory');
    Route::post('sales/store', 'POSController@store');
    Route::post('sales/partial-payment', 'POSController@handlePartialPayment');
    Route::get('sales/destroy/{id}', 'POSController@handleDestroy');
    Route::get('sales/items/{id}', 'POSController@getSaleItems');
    Route::get('sales/details/{reference}', 'POSController@getSaleData');
  });
});

// Shared API'S

Route::group(['namespace' => 'App\Http\Controllers' ,'middleware' => 'auth:api'], function() {
  Route::group(['prefix' => 'users'], function(){
    Route::get('', 'UserController@index');
    Route::get('show/{id}', 'UserController@show');
    Route::post('store', 'UserController@store');
    Route::get('destroy/{id}', 'UserController@destroy');
    Route::get('bulk-destroy/{ids}', 'UserController@bulkDelete');
    Route::get('search', 'UserController@search');
  });

  Route::group(['prefix' =>'companies'], function(){
    Route::get('', 'CompanyController@index');
    Route::get('show/{id}', 'CompanyController@show');
    Route::post('store', 'CompanyController@store');
    Route::get('destroy/{id}', 'CompanyController@destroy');
    Route::get('bulk-destroy/{ids}', 'CompanyController@bulkDelete');
  });

  Route::group(['prefix' => 'insurances'], function(){
    Route::get('', 'InsurancesController@index');
    Route::get('show/{id}', 'InsurancesController@show');
    Route::post('store', 'InsurancesController@store');
    Route::get('destroy/{id}', 'InsurancesController@destroy');
  });

  Route::group(['prefix' => 'roles'], function(){
    Route::get('', 'RolesController@index');
    Route::get('show/{id}', 'RolesController@index');
    Route::post('store', 'RolesController@store');
    Route::get('destroy/{id}', 'RolesController@destroy');
  });

  Route::group(['prefix' => 'departments'], function(){
    Route::get('', 'DepartmentsController@index');
    Route::get('search', 'DepartmentsController@search');
    Route::get('show/{id}', 'DepartmentsController@show');
    Route::post('store', 'DepartmentsController@store');
    Route::get('destroy/{id}', 'DepartmentsController@destroy');
  });

  // Route::group(['prefix' => 'subscription'], function(){
  //   Route::get('', 'SubscriptionController@index');
  //   Route::POST('store', 'SubscriptionController@store');
  // });

});


Route::group(['namespace' => 'App\Http\Controllers\api', 'middleware' => 'auth:api', 'prefix' => 'lab-tests'], function () {
    Route::get('/', 'LabTestCatalogController@index');
    Route::post('store', 'LabTestCatalogController@store');
    Route::post('update/{id}', 'LabTestCatalogController@update');
    Route::get('show/{id}', 'LabTestCatalogController@showByParent');
    Route::get('show/{parent}', 'LabTestCatalogController@showByParent');
    Route::get('destroy/{id}', 'LabTestCatalogController@destroy');
    Route::delete('destroy/{id}', 'LabTestCatalogController@destroy');
});
Route::group(['namespace' => 'App\Http\Controllers\api' ,'middleware' => 'auth:api', 'prefix' => 'lab'], function(){
   Route::get('/requests', 'LabRequestsController@index');
   Route::get('/requests/{id}', 'LabRequestsController@show');
   Route::post('/requests', 'LabRequestsController@store');
   Route::put('/requests/{id}', 'LabRequestsController@update');
   Route::put('/requests/{id}/results', 'LabRequestsController@updateResults');

});

// APIs without auth
Route::group(['namespace' => 'App\Http\Controllers'], function() {
  Route::group(['prefix' => 'subscription'], function(){
    Route::get('', 'SubscriptionController@index');
    Route::POST('store', 'SubscriptionController@store');
  });
});


Route::get('test', function(){
  //return handleConsumedItems(5333, -1000);
});
