<?php

namespace App\Models\Stock;

use App\Models\User;
use App\Models\Company;
use App\Traits\CrudTrait;
use App\Scopes\CompanyScope;
use App\Models\Stock\Currency;
use App\Models\Stock\PurchaseOrderItem;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PurchaseOrder extends Model
{
    use HasFactory, CrudTrait, SoftDeletes;

    protected static function booted()
    {
        static::addGlobalScope(new CompanyScope);
    }

    protected $table = 'purchase_order';
    protected $fillable = [
        'reference',	
        'code',	
        'company_id',	
        'date_initiated',	
        'file_url',	
        'supplier_id',	
        'DocReference',
        'amount',	
        'currency',	
        'status',	
        'created_by',
    ];

    protected $casts = [
        'date_initiated' => 'date'
    ];

    protected $appends = ['total_items'];
    
    public function getTotalItemsAttribute()
    {
        return PurchaseOrderItem::where('order_id', $this->id)->count();
    }

    /**
     * @return BelongsTo
     */
    public function creator()
    {
        return $this->belongsTo(User::class, "created_by")
                    ->select('id','name')
                    ->withTrashed();
    }

        /**
     * @return BelongsTo
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id')
                    ->withTrashed();
    }

    /**
     * @return BelongsTo
     */
    public function company()
    {
        return $this->belongsTo(Company::class, "company_id", 'id')
                    ->select('*')
                    ->withTrashed();
    }

            /**
     * @return BelongsTo
     */
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency')
                    ->select('id','name')
                    ->withTrashed();
    }
}
