<?php
namespace App\Models\Stock;

use App\Models\User;
use App\Models\Company;
use App\Traits\CrudTrait;
use App\Scopes\CompanyScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Proforma extends Model
{
    use HasFactory, CrudTrait, SoftDeletes;

    protected static function booted()
    {
        static::addGlobalScope(new CompanyScope);
    }

    protected $table = 'proforma';

    protected $fillable = [
        'reference',	
        'code',	
        'company_id',	
        'client_id',
        'DocReference',
        'date_initiated',	
        'amount',	
        'status',	
        'created_by',
    ];

    protected $casts = [
        'date_initiated' => 'date'
    ];

    protected $appends = ['total_items'];

        /**
     * @return BelongsTo
     */
    public function client()
    {
        return $this->belongsTo(Client::class, "client_id", 'id')
                    ->select('id', 'name', 'tinnumber', 'phone', 'address')
                    ->withTrashed();
    }

            /**
     * @return BelongsTo
     */
    public function company()
    {
        return $this->belongsTo(Company::class, "company_id", 'id')
                    ->select('*')
                    ->withTrashed();
    }


    public function getTotalItemsAttribute()
    {
        return ProformaItem::where('proforma_id', $this->id)->count();
    }
}