<?php

namespace App\Models\Lab;

use App\Models\Stock\Product;
use Illuminate\Database\Eloquent\Model;

class LabRequestItem extends Model
{
    protected $fillable = [
        'lab_request_id',
        'test_id',
        'price',
        'status',
        'result_value',
        'unit',
        'reference_range',
    ];

    /**
     * Parent lab request.
     */
    public function request()
    {
        return $this->belongsTo(LabRequest::class, 'lab_request_id');
    }

    /**
     * Test product (lab service, is_storable=0).
     */
    public function test()
    {
        return $this->belongsTo(Product::class, 'test_id');
    }
}