<?php

namespace App\Models\Lab;

use App\Models\Stock\Client;
use App\Models\Stock\Sale;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LabRequest extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'patient_id',
        'doctor_name',
        'request_date',
        'priority',
        'sample_type',
        'notes',
        'status',
        'total_amount',
        'created_by',
        // Optional: if your database has this column to link to POS sales
        'sale_id',
    ];

    protected $casts = [
        'request_date'   => 'date',
        'total_amount'   => 'decimal:2',
    ];

    protected $appends = [
        'sale_reference',
    ];

    /**
     * Patient (client) attached to this lab request.
     */
    public function patient()
    {
        return $this->belongsTo(Client::class, 'patient_id');
    }

    /**
     * User who created the request.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Linked POS sale (invoice), if any.
     */
    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sale_id');
    }

    /**
     * Convenience accessor used by API/UI.
     */
    public function getSaleReferenceAttribute(): ?string
    {
        return optional($this->sale)->reference;
    }

    public function items()
    {
        return $this->hasMany(LabRequestItem::class);
    }
}